<?php
// Set proper headers and disable errors in output
header('Content-Type: application/json');
if (ob_get_level()) ob_end_clean();
error_reporting(0);

// Database connection
$host = 'localhost';
$user = 'siyathak_ncharts';
$password = '!7[s6N}T;mw%le~N]9';
$database = 'siyathak_niftycharts';

$mysqli = new mysqli($host, $user, $password, $database);
if ($mysqli->connect_error) {
    echo json_encode(["error" => "Connection failed: " . $mysqli->connect_error]);
    exit;
}

// If filter request
if (isset($_GET['action']) && $_GET['action'] === 'filters') {
    $years = [];
    $months = [];

    $resYear = $mysqli->query("SELECT DISTINCT Year FROM allfut2019  ORDER BY Year DESC");
    while ($row = $resYear->fetch_assoc()) {
        $years[] = $row['Year'];
    }

    $resMonth = $mysqli->query("SELECT DISTINCT Month FROM allfut2019 ORDER BY FIELD(Month, 'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')");
    while ($row = $resMonth->fetch_assoc()) {
        $months[] = [
            "value" => $row['Month'],
            "name" => $row['Month']
        ];
    }

    echo json_encode(["years" => $years, "months" => $months]);
    exit;
}

// Default symbol
$symbol = 'UBL';

// Filters
$year = isset($_GET['year']) ? $mysqli->real_escape_string($_GET['year']) : '';
$month = isset($_GET['month']) ? $mysqli->real_escape_string($_GET['month']) : '';

// Build WHERE clause
$where = "symbol = '$symbol' AND Year > 2018";
if (!empty($year))  $where .= " AND Year = '$year'";
if (!empty($month)) $where .= " AND Month = '$month'";

// Query data
$query = "
    SELECT 
        symbol,
        UNIX_TIMESTAMP(date) AS time,
        date,
        expiry,
        open,
        high,
        low,
        close,
        ltp,
        settle_price,
        volume,
        turnover,
        oi,
        coi,
        spot,
        basis,
        built_up
    FROM allfut2019
    WHERE $where
    ORDER BY date ASC
";

$result = $mysqli->query($query);
if (!$result) {
    echo json_encode(["error" => "Query failed: " . $mysqli->error]);
    exit;
}

// Format result
$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = [
        "symbol" => $symbol,
        "time" => (int)$row["time"],
        "date" => $row["date"],
        "expiry" => $row["expiry"],
        "open" => round((float)$row["open"], 2),
        "high" => round((float)$row["high"], 2),
        "low" => round((float)$row["low"], 2),
        "close" => round((float)$row["close"], 2),
        "ltp" => round((float)$row["ltp"], 2),
        "settle_price" => round((float)$row["settle_price"], 2),
        "volume" => (int)$row["volume"],
        "turnover" => round((float)$row["turnover"], 2),
        "oi" => (int)$row["oi"],
        "coi" => (int)$row["coi"],
        "spot" => round((float)$row["spot"], 2),
        "basis" => round((float)$row["close"] - (float)$row["spot"], 2),
        "built_up" => (int)$row["coi"] > 0
    ? ((float)$row["close"] > (float)$row["open"] ? "Long Buildup" : "Short Covering")
    : ((float)$row["close"] < (float)$row["open"] ? "Short Buildup" : "Long Unwinding"),
    ];
}

echo json_encode($data);
?>
