<?php
$host = 'localhost';
$user = 'siyathak_ncharts';
$password = '!7[s6N}T;mw%le~N]9';
$database = 'siyathak_niftycharts';

$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$expiry = $_GET['expiry'] ?? '';
$date = $_GET['date'] ?? '';

if (empty($expiry) || empty($date)) {
    die(json_encode(["error" => "Missing parameters"]));
}

$sql = "
SELECT 
  C.Option, C.OI, C.OI_Change, C.Volume, C.Turnover, C.Close, C.Strike, C.ATM,
  P.Close AS PE_Close, P.Turnover AS PE_Turnover, P.Volume AS PE_Volume,
  P.OI_Change AS PE_OI_Change, P.OI AS PE_OI, P.Option AS PE_Option,
  P.Spot
FROM astockopt2024 AS C
LEFT JOIN astockopt2024 AS P 
  ON C.Date = P.Date 
  AND C.Expiry = P.Expiry 
  AND C.Strike = P.Strike 
  AND C.Symbol = P.Symbol 
  AND P.Option = 'PE'
WHERE 
  C.Symbol = 'APOLLOHOSP'
  AND C.Option = 'CE'
  AND DATE(C.Expiry) = ?
  AND DATE(C.Date) = ?
ORDER BY C.Date, C.Strike ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $expiry, $date);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    // Add PCR: Put OI / Call OI (rounded to 2 decimals)
    $row['PCR'] = ($row['OI'] > 0) ? round($row['PE_OI'] / $row['OI'], 2) : 0;

    $data[] = $row;
}

echo json_encode(["data" => $data]);
?>
